#pragma once
#include "ftd2xx.h"
#include <string>

typedef enum tagSERIAL_STATE
{
	SS_Unknown,
	SS_UnInit,
	SS_Init,
	SS_Started,
	SS_Stopped,

} SERIAL_STATE;

/// <summary>
/// Holds StMouse position data for a reading.
/// </summary>
struct StPosition {
	/// <summary>
	/// Switch value. Default value is INT_MIN.
	/// </summary>
	int S = INT_MIN;
	/// <summary>
	/// X coordinate. Default value is INT_MIN.
	/// </summary>
	int X = INT_MIN;
	/// <summary>
	/// Y coordinate. Default value is INT_MIN.
	/// </summary>
	int Y = INT_MIN;
	/// <summary>
	/// Z coordinate. Default value is INT_MIN.
	/// </summary>
	int Z = INT_MIN;
};

typedef void (*type_myCallBack) (StPosition);

class StMouse {
private:
	SERIAL_STATE	m_eState;
	FT_HANDLE m_ftHandle;
	type_myCallBack dCallback;
	HANDLE	m_hThread;
	HANDLE	m_hThreadStarted;
	bool	m_abIsConnected;
	CRITICAL_SECTION m_csLock;
	BOOL Setup();
	BOOL SetDataCharacteristics(UCHAR, UCHAR, UCHAR);
	BOOL SetFlowControl(USHORT, UCHAR, UCHAR);
	BOOL SetUSBParameters(DWORD, DWORD);
	SERIAL_STATE GetCurrentState() { return m_eState; }
	void	SetPosition(std::string);
	void	InvalidateHandle(HANDLE& hHandle);
	void	CloseAndCleanHandle(HANDLE& hHandle);
	void	StartListenerThread();
	HRESULT			UnInit();
public:
	StMouse();
	~StMouse();
	StPosition lastPosition;
	FT_STATUS LastCallStatus = FT_OK;
	BOOL Connect(int);
	BOOL ConnectBySerialNumber(PVOID);
	BOOL SetBaudRate(DWORD);
	BOOL SetTimeouts(DWORD, DWORD);
	BOOL Close();
	static std::string GetErrorString(FT_STATUS);
	static unsigned __stdcall ThreadFn(void* pvParam);
	void setDCallback(type_myCallBack cB);

	inline void		LockThis() { EnterCriticalSection(&m_csLock); }
	inline void		UnLockThis() { LeaveCriticalSection(&m_csLock); }
	inline void		InitLock() { InitializeCriticalSection(&m_csLock); }
	inline void		DelLock() { DeleteCriticalSection(&m_csLock); }
	inline bool		IsConnection() { return m_abIsConnected; }
};